/* Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @file  ap_config_layout.h
 * @brief Apache Config Layout
 */

#ifndef AP_CONFIG_LAYOUT_H
#define AP_CONFIG_LAYOUT_H

/* Configured Apache directory layout */
#define DEFAULT_PREFIX "/Applications/AMPPS/apps/apache"
#define DEFAULT_EXP_EXEC_PREFIX "/Applications/AMPPS/apps/apache"
#define DEFAULT_REL_EXEC_PREFIX ""
#define DEFAULT_EXP_BINDIR "/Applications/AMPPS/apps/apache/bin"
#define DEFAULT_REL_BINDIR "bin"
#define DEFAULT_EXP_SBINDIR "/Applications/AMPPS/apps/apache/bin"
#define DEFAULT_REL_SBINDIR "bin"
#define DEFAULT_EXP_LIBEXECDIR "/Applications/AMPPS/apps/apache/modules"
#define DEFAULT_REL_LIBEXECDIR "modules"
#define DEFAULT_EXP_MANDIR "/Applications/AMPPS/apps/apache/man"
#define DEFAULT_REL_MANDIR "man"
#define DEFAULT_EXP_SYSCONFDIR "/Applications/AMPPS/apps/apache/etc"
#define DEFAULT_REL_SYSCONFDIR "etc"
#define DEFAULT_EXP_DATADIR "/Applications/AMPPS/apps/apache/www"
#define DEFAULT_REL_DATADIR "www"
#define DEFAULT_EXP_INSTALLBUILDDIR "/Applications/AMPPS/apps/apache/www/build"
#define DEFAULT_REL_INSTALLBUILDDIR "www/build"
#define DEFAULT_EXP_ERRORDIR "/Applications/AMPPS/apps/apache/www/error"
#define DEFAULT_REL_ERRORDIR "www/error"
#define DEFAULT_EXP_ICONSDIR "/Applications/AMPPS/apps/apache/www/icons"
#define DEFAULT_REL_ICONSDIR "www/icons"
#define DEFAULT_EXP_HTDOCSDIR "/Applications/AMPPS/apps/apache/www/htdocs"
#define DEFAULT_REL_HTDOCSDIR "www/htdocs"
#define DEFAULT_EXP_MANUALDIR "/Applications/AMPPS/apps/apache/www/manual"
#define DEFAULT_REL_MANUALDIR "www/manual"
#define DEFAULT_EXP_CGIDIR "/Applications/AMPPS/apps/apache/www/cgi-bin"
#define DEFAULT_REL_CGIDIR "www/cgi-bin"
#define DEFAULT_EXP_INCLUDEDIR "/Applications/AMPPS/apps/apache/include"
#define DEFAULT_REL_INCLUDEDIR "include"
#define DEFAULT_EXP_LOCALSTATEDIR "/Applications/AMPPS/apps/apache"
#define DEFAULT_REL_LOCALSTATEDIR ""
#define DEFAULT_EXP_RUNTIMEDIR "/Applications/AMPPS/apps/apache/logs"
#define DEFAULT_REL_RUNTIMEDIR "logs"
#define DEFAULT_EXP_LOGFILEDIR "/Applications/AMPPS/apps/apache/logs"
#define DEFAULT_REL_LOGFILEDIR "logs"
#define DEFAULT_EXP_PROXYCACHEDIR "/Applications/AMPPS/apps/apache/proxy"
#define DEFAULT_REL_PROXYCACHEDIR "proxy"

#endif /* AP_CONFIG_LAYOUT_H */
