<?php

function __install(){

	global $__settings, $error, $software, $l, $globals;
	
	$apache_path = dirname(dirname(dirname(__FILE__))).'/apps/apache';
	
	if(!__apache_install_cert()){
		
		// If the certificate generate failed do not load mod_ssl
		$httpd_conf_path = $apache_path.'/etc/httpd.conf';
		$httpd_conf_data = file_get_contents($httpd_conf_path);
		$httpd_conf_data = str_replace('LoadModule ssl_module modules/mod_ssl.so', '#LoadModule ssl_module modules/mod_ssl.so', $httpd_conf_data);
		file_put_contents($httpd_conf_path, $httpd_conf_data);
	}
	
}


function __apache_install_cert(){

	global $__settings, $error, $software, $l, $globals;
	
	$apache_path = dirname(dirname(dirname(__FILE__))).'/apps/apache';
	
	// Make the necessary directories
	@mkdir($apache_path.'/etc/ssl_key');
	@mkdir($apache_path.'/etc/ssl_csr');
	@mkdir($apache_path.'/etc/ssl_crt');
	
	// Create a file with parameters
	$params = "US
New York
New York
Company Inc
Organization
localhost

";
	file_put_contents($apache_path.'/ampps/params.file', $params);
	
	// The command to generate the key and certificate
	$generate_cert_cmd = '"/Applications/AMPPS/apps/bin/openssl" req -config "/Applications/AMPPS/apps/etc/openssl/openssl.cnf" -x509 -sha256 -nodes -days 365 -newkey rsa:2048 -keyout "'.$apache_path.'/etc/ssl_key/server.key" -out "'.$apache_path.'/etc/ssl_crt/server.crt" < "'.$apache_path.'/ampps/params.file"';
	
	shell_exec($generate_cert_cmd);
	
	// Delete the params file
	@unlink($apache_path.'/ampps/params.file');
	
	$ret = false;
	
	// Was the certificate generated successfully ? 
	if(file_exists($apache_path.'/etc/ssl_key/server.key') && file_exists($apache_path.'/etc/ssl_crt/server.crt')){
		$ret = true;
	}
	
	return $ret;

}

__install();